#include <stdio.h>
#include <string.h>
#include "gl.h"


short* Hanzi::hzk12 = NULL;
short* Hanzi::hzk16 = NULL;
char* Hanzi::asc12 = NULL;
char* Hanzi::asc16 = NULL;
char Hanzi::hzk12name[9] = "hzk12";
char Hanzi::hzk16name[9] = "hzk16";
char Hanzi::asc12name[9] = "asc12";
char Hanzi::asc16name[9] = "asc16";
int Hanzi::capabilities = 0;
int Hanzi::size = 0;
int Hanzi::count = 0;
short* Hanzi::hzAddr = NULL;
char* Hanzi::ascAddr = NULL;

Hanzi hz;
extern Hanzi hz;

int hanziInstalled = false;

//ԶεInitHanzi,ÿεֻֿܽװֿжȥ
int InitHanzi( int fonts )
{
	const int  
		asc12len = 1920,
		asc16len = 2560,
		hzk12len = 94*87*12,
		hzk16len = 94*87*16;
		
	FILE *hzk;
	FILE *asc;
	
	if( (fonts & Hanzi::SmallFont && !hanziInstalled ) 
		|| (hanziInstalled && Hanzi::capabilities & Hanzi::SmallFont == 0)){

		if(( hzk = fopen( Hanzi::hzk12name, "rb" )) == NULL ){
			return -1;
			}
		if(( asc = fopen( Hanzi::asc12name, "rb" )) == NULL ){
			fclose( hzk );
			return -1;
			}

		Hanzi::hzk12 = new short[ hzk12len ];
		if( Hanzi::hzk12 == NULL )
			goto hzerror1;
			
		Hanzi::asc12 = new char[ asc12len ];
		if( Hanzi::asc12 == NULL )
			goto hzerror1;
			
		if( fread( Hanzi::hzk12, 2, hzk12len, hzk ) < hzk12len ){
			goto hzerror1;
			}

	// load ascii	
		if( fread( Hanzi::asc12, 1, asc12len, asc ) < asc12len )
			goto hzerror1;
		
		Hanzi::capabilities = Hanzi::SmallFont;
		Hanzi::SetFontSize( 12 );
			
		fclose( hzk );
		fclose( asc );
	} // end of SmallFont


	if(( fonts & Hanzi::MiddleFont && !hanziInstalled )
		&& (hanziInstalled && Hanzi::capabilities & Hanzi::MiddleFont == 0)){

		if(( hzk = fopen( Hanzi::hzk16name, "rb" )) == NULL ){
			return -1;
			}
		if(( asc = fopen( Hanzi::asc16name, "rb" )) == NULL ){
			fclose( hzk );
			return -1;
			}

		Hanzi::hzk16 = new short[ hzk16len ];
		if( Hanzi::hzk16 == NULL )
			goto hzerror1;
			
		Hanzi::asc16 = new char[ asc16len ];
		if( Hanzi::asc16 == NULL )
			goto hzerror1;
			
		if( fread( Hanzi::hzk16, 2, hzk16len, hzk ) < hzk16len ){
			goto hzerror1;
			}

	// load ascii	
		if( fread( Hanzi::asc16, 1, asc16len, asc ) < asc16len )
			goto hzerror1;
		
		Hanzi::capabilities |= Hanzi::MiddleFont;
		Hanzi::SetFontSize( 16 );
		
		fclose( hzk );
		fclose( asc );
	} // end of MiddleFont
	
	Hanzi::capabilities = fonts;
	hanziInstalled = true;
	return 0;

hzerror1:
	delete[] Hanzi::hzk12;
	delete[] Hanzi::asc12;
	delete[] Hanzi::hzk16;
	delete[] Hanzi::asc16;
	fclose( hzk );
	fclose( asc );
	return -1;
	
}



Hanzi::Hanzi()
{
	count ++;
	size = Small;
}

Hanzi::~Hanzi()
{
	if( count == 0 ){
		if( hzk12 )
			delete hzk12;
		if( hzk16 )
			delete hzk16;
		if( asc12 )
			delete asc12;
		if( asc16 )
			delete asc16;
	}
}

int Hanzi::SetFontSize( int fsize )
{
	switch( fsize ){

	case Small:
		if( capabilities & SmallFont ){
			hzAddr = hzk12;
			ascAddr = asc12;
			size = Small;
		}
		else
			return -1;
		break;

	case Middle:
		if( capabilities & MiddleFont ){
			hzAddr = hzk16;
			ascAddr = asc16;
			size = Middle;
		}
		else
			return -1;
		break;
		
	default:
		return -1;
	}
	return 0;
}

void Hanzi::PutAscii( Bitmap* bmp, int x, int y, char* asc )
{
	int mask;
	int i, j;
	char* ascDot;
	
	ascDot = ascAddr + *asc * size;
	
	for( i=0; i<size; i++ ){
		mask = 0x80;
		for( j=0; j<8; j++ ){
			if( mask & *ascDot )
				bmp->PutPixel( x+j, y+i );
			mask >>= 1;
		}
		ascDot ++;
	}
}

void Hanzi::PutHanzi( Bitmap* bmp, int x, int y, char hz[2] )
{
	int mask;
	int i, j;
	short *hzDot;
	
	hzDot = hzAddr + ((hz[0] - 0xa1) * 94 + (hz[1] - 0xa1)) * size;

	for( i=0; i<size; i++ ){
		mask = 0x8000;
		for( j=0; j<size; j++ ){
			if( mask & *hzDot )
				bmp->PutPixel( x+j, y+i );
			mask >>= 1;
		}
		hzDot ++ ;
	}
}

void Hanzi::TextOut( Bitmap* bmp, int x, int y, char* str, int color )
{
#ifdef _DEBUG
//	OutputDebugString( "in Hanzi::TextOut " );
#endif

	bmp->SetColor( color );
	
	int qm, wm;

	while( *str ){
		if( *str > 0xa0 && *(str+1) > 0xa0 ){
			qm = str[0]-0xa1;
			wm = str[1]-0xa1;
			PutHanzi( bmp, x, y, str );
			str += 2;
			x += size;
		}
		else if( *str <= 0xa0 ){
			PutAscii( bmp, x, y, str );
			str ++;
			x += 8;
		}
	}
}
 
void Hanzi::Printf( Bitmap* bmp, int x, int y, int color, char *format, ... )
{
	char buf[256];

	va_list var;
	va_start( var, format );
	_vsnprintf( buf, 255, format, var );
	va_end( var );
	Hanzi::TextOut( bmp, x, y, buf, color );
}
